/*
 dashBy Chart control
 Ver: 1.00
 Date: Apr.25 2016
*/

// List of required files, will be loaded before the control constuctor call
var dashBy_chart_require = ['controls/chart_modules/c3/c3.min.js',
                         'controls/chart_modules/c3/d3.min.js',
                         'controls/chart_modules/c3/pathseg.js',
                         'controls/chart_modules/c3/c3.min.css'];


/// Constructor of the control , called when all required files already loaded
function dashBy_chart(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.data = [];
    this.chart = {};
    this.ready = false;
    this.timelength = 10000;
    this.x_names = [];
    this.y_names = [];
    this.types = [];
    this.colors = [];
    this.datacount = [];
    this.max_points = 1000; // Maximum data points in the buffer
    this.NeedRedraw = true;
    this.rawdata = []; // Raw data buffer
    this.c3data = {
        'xs': [],
        'columns': []
    };

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control text: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    var myStyle = 'display: inline-block; ';
    var x_ticks = 5;
    if (this.options[0].length >= 1) {
        if (this.options[0][0].length > 0) {
            myStyle += 'width:' + this.options[0][0] + 'px; ';
            x_ticks = this.options[0][0] / 50;
            this.max_points = Number(this.options[0][0]) * 2;
            if (this.max_points < 10) this.max_points = 10;
        }
    }


    if (this.options[0].length >= 2) {
        if (this.options[0][1].length > 0) myStyle += 'height:' + this.options[0][1] + 'px; ';
    }
    if (myStyle.length > 0) myStyle = 'style="' + myStyle + '" ';

    if (this.options[0].length >= 3) {
        if (this.options[0][2].length > 0) this.timelength = this.str2ms(this.options[0][2]);
    }
    this.c3axis = {
        x: {
            type: 'timeseries',
            tick: {
                culling: {
                    max: x_ticks
                },
                count: x_ticks,
                format: '%H:%M:%S'
            }
        }
    };

    //    console.log('timelen: ' + this.timelength + " points:  " + this.max_points);

    this.obj.innerHTML = '<div ' + myStyle + ' id="' + this.html_id + '_Chart"></div>'; // Initialise paceholder


    for (var i = 0; i < this.channels.length; i++) {
        this.rawdata[i] = [];
        this.rawdata[i + this.channels.length] = [];
        if (this.options[i + 1] === undefined) {
            this.y_names.push(this.channels[i]);
        } else {
            if ((this.options[i + 1][0] !== undefined) && (this.options[i + 1][0].length > 0)) {
                this.y_names.push(this.options[i + 1][0]);
            } else {
                this.y_names.push(this.channels[i]);
            }
            if ((this.options[i + 1][1] !== undefined) && (this.options[i + 1][1].length > 0)) {
                this.types[this.y_names[this.y_names.length - 1]] = this.options[i + 1][1];
            }
            if ((this.options[i + 1][2] !== undefined) && (this.options[i + 1][2].length > 0)) {
                this.colors[this.y_names[this.y_names.length - 1]] = this.options[i + 1][2];
            }

        }
    }

    for (var i = 0; i < this.channels.length; i++) {
        this.x_names[i] = 'x' + (i + 1);
        this.c3data['xs'][this.y_names[i]] = this.x_names[i];
        this.c3data['columns'][i] = [this.x_names[i]];
        this.c3data['columns'][i + this.channels.length] = [this.y_names[i]];
        this.datacount[i] = 0;
    }

    var param = {
        bindto: '#' + this.html_id + '_Chart',
        data: this.c3data,
        axis: this.c3axis,
        transition: {
            duration: 0
        }
    };

    this.c3data['type'] = 'line';
    if (Object.keys(this.types).length > 0) {
        this.c3data['types'] = [];
        for (key in this.y_names) {
            if (key.length >= 1) {
                this.c3data['types'][key] = 'line';
            }
        }

        for (key in this.types) {
            if (key.length >= 1) {
                this.c3data['types'][key] = this.types[key];
            }
        }
    }

    if (Object.keys(this.colors).length > 0) {
        this.c3data['colors'] = [];
        for (key in this.colors) {
            if (key.length >= 1) {
                this.c3data['colors'][key] = this.colors[key];
            }
        }
    }

    // console.log(this.x_names);
    //  console.log(this.y_names);
    // console.log(this.c3data);
    // console.log(param);

    this.chart = c3.generate(param);

    this.ready = true;

};

/// Required funtion - Update control with new data
dashBy_chart.prototype.update = function (varName, Value, ts) {
    if ((this.obj == null) || (this.ready != true)) return; // skip update of if DOM object does not exist

    var idx = this.channels.indexOf(varName);

    this.rawdata[idx].push(ts); // Push new timestamp
    this.rawdata[idx + this.channels.length].push(Number(Value)); // Push new value
    this.datacount[idx]++;
    this.NeedRedraw = true;
    if (this.rawdata[idx].length > (this.max_points * 4)) this.compressData();
};

dashBy_chart.prototype.compressData = function () {
    var start;
    var end;
    var len;
    for (var i = 0; i < this.channels.length; i++) { // loop over all channels

        // First remove data that is older then max time length
        start = this.rawdata[i].length - 1;
        len = 0;
        //        while ((this.rawdata[i][this.rawdata[i].length - 1] - this.rawdata[i][0]) > this.timelength) {
        //            this.rawdata[i].splice(0, 1);
        //            this.rawdata[i + this.channels.length].splice(0, 1);
        //            this.datacount[i]--;
        ///        }

        while ((this.rawdata[i][start] - this.rawdata[i][len]) > this.timelength) {
            len++;
        }
        this.rawdata[i].splice(0, len);
        this.rawdata[i + this.channels.length].splice(0, len);
        this.datacount[i]--;

        // Now check if amount of data points needs to be reduced
        // Compression algorithm by Kirill Solntsev
        if (this.datacount[i] > this.max_points) {
            var ms_start = this.rawdata[i][0];
            var ms_end = this.rawdata[i][this.rawdata[i].length - 1]
            var ms_per_pixel = (ms_end - ms_start) / this.max_points;
            var k = 0;

            for (var ms_step = ms_start; ms_step <= ms_end; ms_step += ms_per_pixel) {
                var found = false;
                while (this.rawdata[i][k] < ms_step) {
                    if (found) {
                        //                        this.rawdata[i].splice(k, 1);
                        //                        this.rawdata[i + this.channels.length].splice(k, 1);
                        //                        this.datacount[i]--;
                        len++;
                    } else {
                        start = k + 1;
                        len = 0;
                        found = true;
                    }
                    k++;
                    if (k >= this.rawdata[i].length) k = this.rawdata[i].length;
                }
                if (len > 0) {
                    this.rawdata[i].splice(start, len);
                    this.rawdata[i + this.channels.length].splice(start, len);
                    this.datacount[i] -= len;
                    len = 0;
                }
            }
        }
    }

};

// Control redraw function
dashBy_chart.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {

        this.compressData();

        // Update chart data
        for (var i = 0; i < 2 * this.channels.length; i++) { // loop over all channels
            this.c3data['columns'][i].splice(1, this.c3data['columns'][i].length - 1);
            this.c3data['columns'][i] = this.c3data['columns'][i].concat(this.rawdata[i]);
        }
        //      console.log(this.c3data);
        //      console.log(this.rawdata);
    }
    this.chart.load(this.c3data);
    this.NeedRedraw = false;
}


// Helper
dashBy_chart.prototype.str2ms = function (str) {
    var res = 0;
    if (str.indexOf('h') > -1) {
        var t = str.split('h');
        res += Number(t[0]) * 3600;
        str = t[1];
    }
    if (str.indexOf('H') > -1) {
        var t = str.split('H');
        res += Number(t[0]) * 3600;
        str = t[1];
    }
    if (str.indexOf('m') > -1) {
        var t = str.split('m');
        res += Number(t[0]) * 60;
        str = t[1];
    }
    if (str.indexOf('M') > -1) {
        var t = str.split('M');
        res += Number(t[0]) * 60;
        str = t[1];
    }
    if (str.indexOf('s') > -1) {
        var t = str.split('s');
        res += Number(t[0]);
        str = 0;
    } else {
        if (str.indexOf('S') > -1) {
            var t = str.split('S');
            res += Number(t[0]);
            str = 0;
        }
    }
    return (res + Number(str)) * 1000;
}

// --- No code blow this line ----
