/*
 dashBy edit box control
 Ver: 1.00
 Date: Apr.25 2016
*/




function dashBy_editbox(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.SelFlag = false; // Edit box selected flag
    this.updateOnce = false; // Ignore once Edit box selected flag
    this.trim = -1; // Negative value means no trim
    this.leed = 0; // Number of leading spaces
    this.value = '-//-';

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control editbox: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control editbox: no channel defined");
        return;
    }

    //    if ((this.options === null) || (this.options === 0)) {
    //        console.log("dashBy control editbox: no options found");
    //        return;
    //    }


    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) { // Parse format parameters
                if (this.options[0][0].indexOf('.') < 0) { // number of digits after the comma specified
                    this.trim = Number(this.options[0][0]);
                    this.leed = 0;
                } else { // String format like ##.### specified
                    var f = this.options[0][0].split('.');
                    this.leed = f[0].length;
                    this.trim = f[1].length;
                }
            }
        }
        var mySize = '';
        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) mySize = ' size="' + this.options[0][1] + '" ';
        }

        var myStyle = '';
        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) myStyle += 'font-size:' + this.options[0][2] + 'px; ';
        }
        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) myStyle += 'color:' + this.options[0][3] + '; ';
        }

        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) myStyle += 'background-color:' + this.options[0][4] + '; ';
        }

        if (this.options[0].length >= 6) {
            if (this.options[0][5].length > 0) myStyle += 'font-style:' + this.options[0][5] + '; ';
        }
    }
    if (myStyle.length > 0) myStyle = 'style="' + myStyle + '" ';
    this.obj.innerHTML = '<input type="text" id="' + html_id + '_editbox" ' + myStyle + ' maxlength="2048" ' + mySize + '>';
    this.ctrl = document.getElementById(html_id + '_editbox'); // Find HTML DOM object for input text control
    window[html_id + '_editbox_events'] = this;

    this.ctrl.onkeyup = function (ev) {
        window[html_id + '_editbox_events'].keyEvent(window[html_id + '_editbox_events'], ev);
    };

    this.ctrl.onblur = function (ev) {
        window[html_id + '_editbox_events'].selected(window[html_id + '_editbox_events'], 0);
    };

    this.ctrl.onfocus = function (ev) {
        window[html_id + '_editbox_events'].selected(window[html_id + '_editbox_events'], 1);
    };

};

dashBy_editbox.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_editbox.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        if ((this.SelFlag == true) && (this.updateOnce == false)) return; // Skip redraw when edit box is selected
        this.updateOnce = false;

        if (this.trim >= 0) {
            var val = Number(this.value).toFixed(this.trim).toString();
            var spaces = this.leed - val.indexOf('.');
            var prefix = '';
            for (var i = 0; i < spaces; i++) prefix += ' ';
            this.ctrl.value = prefix + val;
        } else {
            this.ctrl.value = this.value;
        }

        this.NeedRedraw = false;
    }
};

dashBy_editbox.prototype.submit = function () {
    if (this.ctrl.value === '') return;
    this.value = this.ctrl.value;
    this.ctrl.value = '';
    this.updateOnce = true;
    dashBy_send(this.channels[0], this.value);
}

dashBy_editbox.prototype.selected = function (self, v) {
    if (v === 0) {
        self.SelFlag = false;
        if (self.value != self.ctrl.value) self.submit();
    } else {
        self.SelFlag = true;
    }
}


dashBy_editbox.prototype.keyEvent = function (self, event) {
    if (event.keyCode == 13) {
        self.submit();
    }
};

///--- end of the control code ---
