/*
 dashBy gauge1 control
 Ver: 1.00
 Date: Apr.25 2016
*/

// List of required files, will be loaded before the control constuctor call
var dashBy_gauge1_require = ['controls/chart_modules/c3/c3.min.js',
                         'controls/chart_modules/c3/d3.min.js',
                         'controls/chart_modules/c3/pathseg.js',
                         'controls/chart_modules/c3/c3.min.css'];


/// Constructor of the control , called when all required files already loaded
function dashBy_gauge1(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.trim = -1; // Negative value means no trim
    this.leed = 0; // Number of leading spaces
    this.value = NaN;
    this.config = {
        size: 120,
        label: '',
        min: 0,
        max: 100,
        thickness: 29
    };
    this.color_scheme = {
        pattern: ['#FF0000', '#00FF00', '#00FF00', '#FF0000'], // the three color levels for the percentage values.
        //            pattern: ['#FF0000', '#F97600', '#F6C600', '#60B044'], // the three color levels for the percentage values.
        threshold: {
            //            unit: 'value', // percentage is default
            //            max: 200, // 100 is default
            values: [-200, 0, 200]
        }
    }


    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control gauge1: Error, can't find HTML object with id=" + this.html_id);
        return;
    }


    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control gaguge1: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control gauge1: no options found");
        return;
    }


    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) { // Parse format parameters
                if (this.options[0][0].indexOf('.') < 0) { // number of digits after the comma specified
                    this.trim = Number(this.options[0][0]);
                    this.leed = 0;
                } else { // String format like ##.### specified
                    var f = this.options[0][0].split('.');
                    this.leed = f[0].length;
                    this.trim = f[1].length;
                }
            }
        }


        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) this.config.min = Number(this.options[0][1]);
        }
        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) this.config.max = Number(this.options[0][2]);
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) this.config.label = this.options[0][3].trim();
        }
        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) this.config.size = Number(this.options[0][4]);
        }
        if (this.config.size < 50) this.config.size = 50;

        if (this.options[0].length >= 6) {
            if (this.options[0][5].length > 0) this.config.thickness = Number(this.options[0][5]);
        }
        if (this.config.thickness < 2) this.config.thickness = 2;
    }


    this.color_scheme.threshold.values[0] = this.config.min;
    this.color_scheme.threshold.values[1] = (this.config.max + this.config.min) / 2;
    this.color_scheme.threshold.values[2] = this.config.max;

    if (this.options.length > 1) {
        if (this.options[1].length >= 7) {
            if (this.options[1][0].length > 0) this.color_scheme.pattern[0] = this.options[1][0];
            if (this.options[1][1].length > 0) this.color_scheme.threshold.values[0] = this.options[1][1];
            if (this.options[1][2].length > 0) this.color_scheme.pattern[1] = this.options[1][2];
            if (this.options[1][3].length > 0) this.color_scheme.threshold.values[1] = this.options[1][3];
            if (this.options[1][4].length > 0) this.color_scheme.pattern[2] = this.options[1][4];
            if (this.options[1][5].length > 0) this.color_scheme.threshold.values[2] = this.options[1][5];
            if (this.options[1][6].length > 0) this.color_scheme.pattern[3] = this.options[1][6];
        }
    }

    //
    var myStyle = 'style="display: inline-block; width:' + this.size + 'px;"';

    this.obj.innerHTML = '<div ' + myStyle + ' id="' + this.html_id + '_gauge1"></div>';

    this.chart = c3.generate({
        data: {
            columns: [
                ['data', 0]
            ],
            type: 'gauge',
            onclick: function (d, i) {
                //                console.log("onclick", d, i);
                //            },
                //            onmouseover: function (d, i) {
                //                console.log("onmouseover", d, i);
                //            },
                //            onmouseout: function (d, i) {
                //                console.log("onmouseout", d, i);
            }
        },
        bindto: '#' + this.html_id + '_gauge1',
        gauge: {
            label: {
                format: function (value, ratio) {
                    return value;
                },
                show: true // to turn off the min/max labels.
            },
            min: this.config.min, // 0 is default
            max: this.config.max, // 100 is default
            units: this.config.label,
            width: this.config.thickness // for adjusting arc thickness
        },
        color: this.color_scheme,
        size: {
            height: this.config.size / 2,
            width: this.config.size
        }
    });

    this.ready = true;
};

/// Required funtion - Update control with new data
dashBy_gauge1.prototype.update = function (varName, Value, ts) {
    if ((this.obj == null) || (this.ready != true)) return; // skip update of if DOM object does not exist
    this.value = Value;
    this.NeedRedraw = true;
};


// Control redraw function
dashBy_gauge1.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        this.chart.load({
            columns: [['data', this.value]]
        });
        this.NeedRedraw = false;
    }
};

//------- end of code ---------
