/*
 dashBy gauge2 control
 Ver: 1.00
 Date: Apr.25 2016
 INFO: Built using gauge.js library from 'Tomer Doron'
 https://gist.github.com/tomerd/1499279
*/

// List of required files, will be loaded before the control constuctor call
var dashBy_gauge2_require = ['controls/gauge2_files/gauge.js',
                             'controls/chart_modules/c3/d3.min.js'];


function dashBy_gauge2(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.trim = -1; // Negative value means no trim
    this.leed = 0; // Number of leading spaces
    this.value = NaN;
    this.config = {
        size: 120,
        label: '',
        min: 0,
        max: 100,
        minorTicks: 5
    };


    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control gauge2: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control gaguge2: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control gauge2: no options found");
        return;
    }


    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) { // Parse format parameters
                if (this.options[0][0].indexOf('.') < 0) { // number of digits after the comma specified
                    this.trim = Number(this.options[0][0]);
                    this.leed = 0;
                } else { // String format like ##.### specified
                    var f = this.options[0][0].split('.');
                    this.leed = f[0].length;
                    this.trim = f[1].length;
                }
            }
        }


        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) this.config.min = Number(this.options[0][1]);
        }
        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) this.config.max = Number(this.options[0][2]);
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) this.config.label = this.options[0][3].trim();
        }
        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) this.config.size = Number(this.options[0][4]);
        }
        if (this.size < 50) this.size = 50;

        if (this.options[0].length >= 7) {
            var min = this.config.min;
            var max = this.config.max;
            this.config.yellowZones = [];
            if (this.options[0][5].length > 0) min = Number(this.options[0][5]);
            if (this.options[0][6].length > 0) max = Number(this.options[0][6]);
            var range = {
                from: min,
                to: max
            };
            this.config.yellowZones[0] = range;
        }

        if (this.options[0].length >= 9) {
            var min = this.config.min;
            var max = this.config.max;
            this.config.redZones = [];
            if (this.options[0][7].length > 0) min = Number(this.options[0][7]);
            if (this.options[0][8].length > 0) max = Number(this.options[0][8]);
            var range = {
                from: min,
                to: max
            };
            this.config.redZones[0] = range;
        }
    }

    this.obj.innerHTML = '';
    this.gauge = new Gauge(html_id, this.config);
    this.gauge.render();
};

dashBy_gauge2.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_gauge2.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        if (isNaN(this.value)) return;
        if (this.trim >= 0) {
            var val = Number(this.value).toFixed(this.trim).toString();
            var spaces = this.leed - val.indexOf('.');
            var prefix = '';
            for (var i = 0; i < spaces; i++) prefix += ' ';
            this.gauge.redraw(Number(val));

        } else {
            this.gauge.redraw(Number(this.value));
        }
        this.NeedRedraw = false;
    }
};



///----- End of control ------
