/*
 dashBy gauge 3control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_gauge3(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.trim = -1; // Negative value means no trim
    this.leed = 0; // Number of leading spaces
    this.value = '-//-';
    this.size = 120;
    this.min = 0;
    this.max = 100;
    this.span = this.max - this.min;
    this.color = 'yellow';
    this.myLabel = '';
    this.myUnit = '';



    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control text: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control number: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control number: no options found");
        return;
    }


    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) { // Parse format parameters
                if (this.options[0][0].indexOf('.') < 0) { // number of digits after the comma specified
                    this.trim = Number(this.options[0][0]);
                    this.leed = 0;
                } else { // String format like ##.### specified
                    var f = this.options[0][0].split('.');
                    this.leed = f[0].length;
                    this.trim = f[1].length;
                }
            }
        }

        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) this.min = Number(this.options[0][1]);
        }
        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) this.max = Number(this.options[0][2]);
        }

        this.span = this.max - this.min;

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) this.color = this.options[0][3].trim();
        }
        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) this.size = Number(this.options[0][4]);
        }
        if (this.size < 25) this.size = 25;

        var myStyle = '';
        var myLabelStyle = '';
        if (this.options[0].length >= 6) {
            if (this.options[0][5].length > 0) {
                var fontSize = Number(this.options[0][5]);
                myStyle += ' font-size:' + fontSize + 'px; ';
                fontSize = (Number(fontSize) * 0.7).toFixed(0).toString();
                myLabelStyle += ' font-size:' + fontSize + 'px; ';
            }
        }
        if (this.options[0].length >= 7) {
            if (this.options[0][6].length > 0) {
                myStyle += ' color:' + this.options[0][6] + '; ';
                myLabelStyle += ' color:' + this.options[0][6] + '; ';
            }
        }

        if (this.options[0].length >= 8) {
            if (this.options[0][7].length > 0) this.myLabel = this.options[0][7];
        }

        if (this.options[0].length >= 9) {
            if (this.options[0][8].length > 0) this.myUnit = this.options[0][8];
        }


        if (myStyle.length > 0) this.obj.style = myStyle; // Initialise style
    }



    var tmpObj = '<div id = "' + html_id + '_Gauge"';
    tmpObj += 'style = "background-position : 50% 50%; background-size: cover; background-repeat: no-repeat; display: table-cell; vertical-align:middle; text-align:center; width:' + this.size + 'px; height:' + this.size + 'px;" >';
    tmpObj += '<div id = "' + html_id + '_GaugeText" > &nbsp; </div> <div id = "' + html_id + '_GaugeValue" > - //-</div>';
    tmpObj += '<div id = "' + html_id + '_GaugeUnit" > &nbsp; </div> </div>';
    this.obj.innerHTML = tmpObj; //this.value; // Initialise with dummy value
    this.obj.gauge = document.getElementById(html_id + '_Gauge'); // Find HTML DOM object
    this.obj.gaugeText = document.getElementById(html_id + '_GaugeText'); // Find HTML DOM object
    this.obj.gaugeValue = document.getElementById(html_id + '_GaugeValue'); // Find HTML DOM object
    this.obj.gaugeUnit = document.getElementById(html_id + '_GaugeUnit'); // Find HTML DOM object

    this.bgPicture = ".png'),url('controls/gauge3_files/cg_yellow.png')";
    if (this.color == 'green') this.bgPicture = ".png'),url('controls/gauge3_files/cg_green.png')";
    if (this.color == 'blue') this.bgPicture = ".png'),url('controls/gauge3_files/cg_blue.png')";

    this.obj.gauge.style.backgroundImage = "url('controls/gauge3_files/L1" + this.bgPicture;
    this.obj.gauge.style.backgroundSize = 'contain,contain';

    this.obj.gaugeText.style = myLabelStyle;
    this.obj.gaugeValue.style = myStyle;
    this.obj.gaugeUnit.style = myLabelStyle;
    this.obj.gaugeText.innerHTML = this.myLabel;
    this.obj.gaugeUnit.innerHTML = this.myUnit;

};

dashBy_gauge3.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_gauge3.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        if (this.trim >= 0) {
            var val = Number(this.value).toFixed(this.trim).toString();
            var spaces = this.leed - val.indexOf('.');
            var prefix = '';
            for (var i = 0; i < spaces; i++) prefix += '&nbsp;';
            this.obj.gaugeValue.innerHTML = prefix + val;
        } else {
            this.obj.gaugeValue.innerHTML = this.value;
        }

        v = 20 * (this.value - this.min) / this.span;
        v = Math.round(v);
        if (v > 20) v = 20;
        if (v < 1) v = 1;
        this.obj.gauge.style.backgroundImage = "url('controls/gauge3_files/L" + v.toString() + this.bgPicture;
        this.NeedRedraw = false;
    }
};



///----- End of control ------
