/*
 dashBy Listbox control
 Ver: 1.00
 Date: Apr.25 2016
*/




function dashBy_listbox(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.SelFlag = false; // List box selected flag
    this.updateOnce = false; // Ignore once List box selected flag
    this.value = '-//-';
    this.OptionsList=[];
    this.OptionsList[0]={
    text:'--//--',
    value: Number.NEGATIVE_INFINITY
    };

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control listbox: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control listbox: no channel defined");
        return;
    }

        if ((this.options === null) || (this.options === 0)) {
            console.log("dashBy control listbox: no options found");
            return;
        }
   
    for(var i=0; i< this.options.length; i++)
    {
     if (this.options[i].length <2) {
      console.log('listbox control: invalid option found '+this.options[i]);
      continue;
     }

     this.OptionsList.push({
      text: this.options[i][0],
      value: Number(this.options[i][1])
     });
    }

    var s="<select id='"+html_id+"_listbox'>\n";
    for(var i=0; i<this.OptionsList.length;i++){
     s += "<option value='"+this.OptionsList[i].value+"'>"+this.OptionsList[i].text+"</option>\n";
    }
    s += "</select>\n";
    
    this.obj.innerHTML = s;
    this.ctrl = document.getElementById(html_id + '_listbox'); // Find HTML DOM object for input text control
    window[html_id + '_listbox_events'] = this;
    
        this.ctrl.onfocus = function (ev) {
        window[html_id + '_listbox_events'].selected(window[html_id + '_listbox_events'], 1);
    };
    
        this.ctrl.onblur = function (ev) {
        window[html_id + '_listbox_events'].selected(window[html_id + '_listbox_events'], 0);
    };

    this.ctrl.onchange = function (ev) {
        window[html_id + '_listbox_events'].onchange(window[html_id + '_listbox_events'], ev);
    };

};

dashBy_listbox.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_listbox.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        if ((this.SelFlag == true) && (this.updateOnce == false)) return; // Skip redraw when edit box is selected
        this.updateOnce = false;

        for(var i=0; i<this.OptionsList.length;i++){
         if(this.value == this.OptionsList[i].value){
          this.ctrl.value=this.value;
          this.NeedRedraw = false;
          return;
         }
        }   
        this.ctrl.value=Number.NEGATIVE_INFINITY; 
        this.NeedRedraw = false;
    }
};

dashBy_listbox.prototype.submit = function () {
    if (this.ctrl.value==Number.NEGATIVE_INFINITY) return;
//    console.log(this.ctrl.value);
    this.value = this.ctrl.value;
    this.ctrl.value = Number.NEGATIVE_INFINITY;
    this.updateOnce = true;
    dashBy_send(this.channels[0], this.value);
}

dashBy_listbox.prototype.selected = function (self, v) {
    if (v === 0) {
        self.SelFlag = false;
        if (self.value != self.ctrl.value) self.submit();
    } else {
        self.SelFlag = true;
    }
}


dashBy_listbox.prototype.onchange = function (self, event) {
        self.submit();
};

///--- end of the control code ---
