/*
 dashBy number control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_number(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.trim = -1; // Negative value means no trim
    this.leed = 0; // Number of leading spaces
    this.value = '-//-';

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control number: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control number: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control number: no options found");
        return;
    }


    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) { // Parse format parameters
                if (this.options[0][0].indexOf('.') < 0) { // number of digits after the comma specified
                    this.trim = Number(this.options[0][0]);
                    this.leed = 0;
                } else { // String format like ##.### specified
                    var f = this.options[0][0].split('.');
                    this.leed = f[0].length;
                    this.trim = f[1].length;
                }
            }
        }

        var myStyle = 'font-family: "Courier New", Courier, monospace; ';
        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) myStyle += 'font-size:' + this.options[0][1] + 'px; ';
        }
        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) myStyle += 'color:' + this.options[0][2] + '; ';
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) myStyle += 'background-color:' + this.options[0][3] + '; ';
        }

        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) myStyle += 'font-style:' + this.options[0][4] + '; ';
        }


        if (myStyle.length > 0) this.obj.style = myStyle; // Initialise style
    }

    this.obj.innerHTML = this.value; // Initialise with dummy value
};

dashBy_number.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_number.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        if (this.trim >= 0) {
            var val = Number(this.value).toFixed(this.trim).toString();
            var spaces = this.leed - val.indexOf('.');
            var prefix = '';
            for (var i = 0; i < spaces; i++) prefix += '&nbsp;';
            this.obj.innerHTML = prefix + val;
        } else {
            this.obj.innerHTML = this.value;
        }

        this.NeedRedraw = false;
    }
};
