/*
 dashBy text control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_online(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.timeoutMessage = '- CONNECTION LOST -';
    this.waitMessage = '- WAIT -';
    this.onlineMessage = '- ONLINE -';
    this.online = 1000;
    this.wait = 5000;
    this.state = 2;
    this.value = '-\\\\-';

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control online: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    var myStyle = '';

    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) this.onlineMessage = this.options[0][0];
        }

        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) this.waitMessage = this.options[0][1];
        }

        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) this.timeoutMessage = this.options[0][2];
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) myStyle += 'font-size:' + this.options[0][3] + 'px; '
        }

        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) myStyle += 'color:' + this.options[0][4] + '; ';
        }

        if (this.options[0].length >= 6) {
            if (this.options[0][5].length > 0) myStyle += 'background-color:' + this.options[0][5] + '; ';
        }

        if (this.options[0].length >= 7) {
            if (this.options[0][6].length > 0) myStyle += 'font-style:' + this.options[0][6] + '; ';
        }
        if (myStyle.length > 0) this.obj.style = myStyle; // Initialise style
    }

    this.obj.innerHTML = this.waitMessage; // Initialise with dummy value
    this.lastTime = 0;
};

dashBy_online.prototype.update = function (varName, Value, ts) {
    var b = new Date();
    this.lastTime = b.getTime();
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_online.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        //        this.NeedRedraw = false;
        if (this.obj == null) return; // skip redraw of if DOM object does not exist

        if (this.lastTime == 0) {
            this.obj.innerHTML = this.waitMessage;
            this.state = 2;
            return;
        }

        var b = new Date();

        if ((b.getTime() - this.lastTime) < this.online) {
            if (this.state == 1) return; // No need to refresh
            this.state = 1
            this.obj.innerHTML = this.onlineMessage;
            return;
        }


        if ((b.getTime() - this.lastTime) < this.wait) {
            this.obj.innerHTML = this.waitMessage;
            if (this.state == 2) return; // No need to refresh
            this.state = 2;
            return;
        }

        if (this.state == 3) return; // No need to refresh
        this.state = 3;
        this.obj.innerHTML = this.timeoutMessage;
        //this.obj.innerHTML = b.getTime() - this.lastTime
    }
};

//--- Nothing below this line ---
