/*
 dashBy picture control
 Ver: 1.00
 Date: Aug.25 2016
*/

function dashBy_picture(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.range = [];
    this.style = '';


    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control picture: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control picture: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control picture: no options found");
        return;
    }


    if (this.options[0].length > 0) {
        if (this.options[0][0].length > 0) {
            this.url = this.options[0][0];
        } else {
            console.log("dashBy control picture: missed picture URL");
            return;
        }

        if (this.options[0].length > 1) {
            if (this.options[0][1].length > 0) {
                this.width = Number(this.options[0][1]);
                this.style = 'width: ' + this.width + 'px;';
            }
        }

        if (this.options[0].length > 2) {
            if (this.options[0][2].length > 0) {
                this.height = Number(this.options[0][2]);
                this.style += ' height: ' + this.height + 'px;';
            }
        }

        if (this.style.length > 0) this.style = 'style="' + this.style + '"';
    } else {
        console.log("dashBy control picture: too few options");
        return;
    }

    for (var i = 1; i < this.options.length; i++) // Loop over ranges
    {
        if (this.options[i].length < 3) continue;
        var thisRange = {
            from: Number(this.options[i][0]),
            to: Number(this.options[i][1]),
            url: this.options[i][2]
        };
        this.range[i - 1] = thisRange;
    }

    var tmpObj = '<img id = "' + html_id + '_img" src="';
    tmpObj += this.url + '" ' + this.style + '/>';
    this.obj.innerHTML = tmpObj;
    this.myImg = document.getElementById(html_id + '_img'); // Find HTML DOM object for the image
    this.myImg.src = this.url;
};

dashBy_picture.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_picture.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist

        var url = this.url;

        for (var i = 0; i < this.range.length; i++) {
            if ((this.value >= this.range[i].from) && (this.value <= this.range[i].to)) {
                url = this.range[i].url;
                break;
            }
        }
        this.myImg.src = url;
        this.NeedRedraw = false;
    }
};



///----- End of control ------
