/*
 dashBy range control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_range(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.min = 0;
    this.max = 100;
    this.step = 1;
    this.selFlag = false;
    this.NeedRedraw = false;
    this.width = 100;
    this.height = 50;


    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control range: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control range: no channel defined");
        return;
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control range: no options found");
        return;
    }


    if (this.options[0].length >= 1) {
        if (this.options[0][0].length > 0) this.min = Number(this.options[0][0]);
    }

    if (this.options[0].length >= 2) {
        if (this.options[0][1].length > 0) this.max = Number(this.options[0][1]);
    }

    if (this.options[0].length >= 3) {
        if (this.options[0][2].length > 0) this.step = Number(this.options[0][2]);
    }
    var myStyle = '';

    if (this.options[0].length >= 4) {
        if (this.options[0][3].length > 0) {
            this.width = Number(this.options[0][3]);
            myStyle += 'width:' + this.options[0][3] + 'px; ';
        }
    }
    if (this.options[0].length >= 5) {
        if (this.options[0][4].length > 0) {
            this.height = Number(this.options[0][4]);
            myStyle += 'height:' + this.options[0][4] + 'px; ';
        }
    }

    if (this.height > this.width) myStyle += " -webkit-appearance: slider-vertical; ";

    if (myStyle.length > 0) myStyle = 'style="' + myStyle + '" ';


    var varname = '';
    for (var i = 0; i < this.channels[0].length; i++) {
        if (this.channels[0][i] != '\\') varname += this.channels[0][i];
        else varname += '\\\\';
    }
    this.obj.innerHTML = "<input type='range' id='" + this.html_id + "_range' min='" + this.min + "' max='" + this.max + "' step='" + this.step + "'" + myStyle + " oninput=\"dashBy_send('" + varname + "',this.value);\" onichange=\"dashBy_send('" + varname + "',this.value);\">";
    this.ctrl = document.getElementById(html_id + '_range'); // Find HTML DOM object for input text control
    window[html_id + '_range_events'] = this;

    this.ctrl.onmouseleave = function (ev) {
        window[html_id + '_range_events'].selected(window[html_id + '_range_events'], 0);
    };

    this.ctrl.onfocus = function (ev) {
        window[html_id + '_range_events'].selected(window[html_id + '_range_events'], 1);
    };


};

dashBy_range.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
    return;
};

// Control redraw function
dashBy_range.prototype.redraw = function (Forceredraw) {
    if (this.SelFlag == true) return;
    if (this.NeedRedraw == false) return;
    this.ctrl.value = this.value;
    this.NeedRedraw = false;
    return;
}

dashBy_range.prototype.selected = function (self, v) {
    if (v === 0) {
        self.SelFlag = false;
    } else {
        self.SelFlag = true;
    }
}



//---- End of the control code ---
