/*
 dashBy switch control
 Ver: 1.00
 Date: Aug.25 2016
*/


function dashBy_switch(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.valOff = 0;
    this.valOn = 1;
    this.picOff = 'controls/switch_files/bttnOff.png';
    this.picOn = 'controls/switch_files/bttnOn.png';
    this.style = '';
    this.isOn = false;

    window['dashBy_' + html_id + '_switch'] = this;

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control switch: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    if ((this.channels === null) || (this.channels.length === 0)) {
        console.log("dashBy control switch: no channel defined");
        return;
    }

    this.varname = '';
    for (var i = 0; i < this.channels[0].length; i++) {
        if (this.channels[0][i] != '\\') this.varname += this.channels[0][i];
        else this.varname += '\\\\';
    }

    if ((this.options === null) || (this.options === 0)) {
        console.log("dashBy control switch: no options found");
        return;
    }


    if (this.options[0].length > 0) {
        if (this.options[0][0].length > 0) {
            this.valOff = Number(this.options[0][0]);
        }
    }

    if (this.options[0].length > 1) {
        if (this.options[0][1].length > 0) {
            this.valOn = Number(this.options[0][1]);
        }
    }

    if (this.options[0].length > 2) {
        if (this.options[0][2].length > 0) {
            this.width = Number(this.options[0][2]);
            this.style = 'width: ' + this.width + 'px;';
        }
    }

    if (this.options[0].length > 3) {
        if (this.options[0][3].length > 0) {
            this.height = Number(this.options[0][3]);
            this.style += ' height: ' + this.height + 'px;';
        }
    }

    if (this.style.length > 0) this.style = 'style="' + this.style + '"';

    if (this.options[0].length > 4) {
        if (this.options[0][4].length > 0) {
            this.picOff = this.options[0][4];
        }
    }

    if (this.options[0].length > 5) {
        if (this.options[0][5].length > 0) {
            this.picOn = this.options[0][5];
        }
    }

    var tmpObj = '<img id = "' + html_id + '_img" name="' + html_id + '_switch" src="';
    tmpObj += this.url + '" ' + this.style + '" onclick="window[\'dashBy_' + html_id + '_switch\'].toggle();"/>';
    this.obj.innerHTML = tmpObj;
    this.myImg = document.getElementById(html_id + '_img'); // Find HTML DOM object for the image
    this.myImg.src = this.picOff;

    this.value = this.valOff;

    //    this.myImg.onclick = function () {
    //        that.toggle(that);
    //    };

    dashBy_switch.prototype.toggle = function () {
        if (this.isOn) {
            this.isOn = false;
            dashBy_send(this.varname, this.valOff);
            this.myImg.src = this.picOff;
        } else {
            this.isOn = true;
            dashBy_send(this.varname, this.valOn);
            this.myImg.src = this.picOn;
        }
    };

    dashBy_switch.prototype.update = function (varName, Value, ts) {
        this.value = Value;
        this.NeedRedraw = true;
        return;
    };

    // Control redraw function
    dashBy_switch.prototype.redraw = function (Forceredraw) {
        if (Forceredraw == undefined) Forceredraw = false;
        if ((this.NeedRedraw == true) || (Forceredraw == true)) {
            if (this.obj == null) return; // skip redraw of if DOM object does not exist

            if (Math.abs(this.value - this.valOff) < Math.abs(this.value - this.valOn)) {
                this.myImg.src = this.picOff;
            } else {
                this.myImg.src = this.picOn;
            }
            this.NeedRedraw = false;
        }
    };

};


///----- End of control ------
