/*
 dashBy text control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_text(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.value = '-\\\\-';

    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control text: Error, can't find HTML object with id=" + this.html_id);
        return;
    }

    var myStyle = '';

    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) myStyle += 'font-size:' + this.options[0][0] + 'px; ';
        }

        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) myStyle += 'color:' + this.options[0][1] + '; ';
        }

        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) myStyle += 'background-color:' + this.options[0][2] + '; ';
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) myStyle += 'font-style:' + this.options[0][3] + '; ';
        }

        if (myStyle.length > 0) this.obj.style = myStyle; // Initialise style
    }

    this.obj.innerHTML = "-\\\\-"; // Initialise with dummy value
};

dashBy_text.prototype.update = function (varName, Value, ts) {
    this.value = Value;
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_text.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        this.obj.innerHTML = this.value;
        this.NeedRedraw = false;
    }
};
