/*
 dashBy trace control
 Ver: 1.00
 Date: Apr.25 2016
*/

function dashBy_trace(html_id, channels, options) {
    this.html_id = html_id;
    this.channels = channels;
    this.options = options;
    this.NeedRedraw = true;
    this.value = [];
    this.counter = 0;
    this.width = 300;
    this.height = 200;
    this.fontsize = 16;
    this.timestamp = 1;


    this.obj = document.getElementById(html_id); // Find HTML DOM object
    if ((this.obj === null) || (this.obj.length === 0)) {
        console.log("dashBy control text: Error, can't find HTML object with id=" + this.html_id);
        return;
    }


    var myStyle = '';

    if (this.options[0].length > 0) {

        if (this.options[0].length >= 1) {
            if (this.options[0][0].length > 0) this.width = this.options[0][0];
        }

        if (this.options[0].length >= 2) {
            if (this.options[0][1].length > 0) this.height = this.options[0][1];
        }

        if (this.options[0].length >= 3) {
            if (this.options[0][2].length > 0) this.timestamp = this.options[0][2];
        }

        if (this.options[0].length >= 4) {
            if (this.options[0][3].length > 0) {
                myStyle += 'font-size:' + this.options[0][3] + 'px; ';
                this.fontsize = this.options[0][3];
            }
        }

        if (this.options[0].length >= 5) {
            if (this.options[0][4].length > 0) myStyle += 'color:' + this.options[0][4] + '; ';
        }

        if (this.options[0].length >= 6) {
            if (this.options[0][5].length > 0) myStyle += 'background-color:' + this.options[0][5] + '; ';
        }

        if (this.options[0].length >= 7) {
            if (this.options[0][6].length > 0) myStyle += 'font-style:' + this.options[0][6] + '; ';
        }

        myStyle += 'width:' + this.width + 'px; height:' + this.height + 'px; '
        this.obj.style = myStyle; // Initialise style
        ;
    }

    this.length = (this.height / this.fontsize / 1.34);

    this.obj.innerHTML = '<select id="' + html_id + '_trace" class="control trace" style="' + myStyle + '"size="3"></select>';
    this.innerObj = document.getElementById(html_id + '_trace');
};

dashBy_trace.prototype.update = function (varName, Value, ts) {
    var datetime = '';
    if (this.timestamp == 0) {
        this.value.push(Value);
    } else {
        var currentdate = new Date(ts);
        var ms = currentdate.getMilliseconds().toString();
        while (ms.length < 3) ms = '0' + ms;
        if (this.timestamp == 1) {
            datetime = currentdate.getHours() + ":" + currentdate.getMinutes() + ":" + currentdate.getSeconds() + '.' + ms;
        } else {
            datetime = currentdate.getDate() + "/" + (currentdate.getMonth() + 1) + "/" + currentdate.getFullYear() + " " + currentdate.getHours() + ":" + currentdate.getMinutes() + ":" + currentdate.getSeconds() + '.' + ms;
        }
        this.value.push('[' + datetime + '] ' + Value);
    }
    this.NeedRedraw = true;
};

// Control redraw function
dashBy_trace.prototype.redraw = function (Forceredraw) {
    if (Forceredraw == undefined) Forceredraw = false;
    if ((this.NeedRedraw == true) || (Forceredraw == true)) {
        if (this.obj == null) return; // skip redraw of if DOM object does not exist
        //      this.obj.innerHTML = this.value;
        //innerObj
        while (this.value.length > 0) {
            var v = this.value.pop();
            var option = document.createElement("option");
            option.value = v;
            option.text = v;
            this.innerObj.appendChild(option);
            this.counter++;
            if (this.counter > this.length) {
                this.innerObj.remove(0);
                this.counter--;
            }
        }
        this.NeedRedraw = false;
    }
};

//--- Nothing below this line ------
