var http = require("http")
var WebSocketServer = require('./websocket').server;
var url = require("url")
var path = require("path")
var fs = require("fs")
var ini = require("./ini")

var MediatorGate = require("./mediator_lib")

var Config = {
    'http_port': 8080,
    'websock_timeout': 2000,
    'mediator_host': 'localhost',
    'mediator_port': 7777,
    'mediator_mask': '*'
};

var ini_filename = '';

// -- Begin command line parameters
var cmd = '';
process.argv.forEach(function (val, index, array) {
    if (val.substring(0, 1) == '-') // Option prefix
    {
        cmd = val;
    } else {
        if (cmd == '-c') ini_filename = val; // Ini file option
    }
});
// -- End command line parameters

// -- Begin Processs ini file
if (ini_filename.length > 1) {
    var ini_config = ini.parse(fs.readFileSync(ini_filename, 'utf-8'));
    if (ini_config["http"] != undefined) {
        if (ini_config["http"]["port"] != undefined)
            Config.http_port = ini_config["http"]["port"];
    }

    if (ini_config["websock"] != undefined) {
        if (ini_config["websock"]["timeout"] != undefined)
            Config.websock_timeout = ini_config["websock"]["timeout"];
    }

    if (ini_config["mediator"] != undefined) {
        if (ini_config["mediator"]["host"] != undefined)
            Config.mediator_host = ini_config["mediator"]["host"];
        if (ini_config["mediator"]["port"] != undefined)
            Config.mediator_port = ini_config["mediator"]["port"];
        if (ini_config["mediator"]["mask"] != undefined)
            Config.mediator_mask = ini_config["mediator"]["mask"];
    }
}
// -- End process ini files

// -- Begin Webserver part
if ((Config.http_port.toString().length > 1) && (Config.http_port.toString().trim() != 'none')) {
    console.log('Starting HTTP Webserver at: ' + Config.http_port);
    var httpsrv = http.createServer(function (request, response) {
        if (request.method == 'POST') {
            var uri = url.parse(request.url).pathname,
                filename = path.join(process.cwd(), uri);
            console.log("POST:" + filename);
            var body = '';
            request.on('data', function (data) {
                body += data;
                console.log("Partial body: " + unescape(body.replace(/\+/g, ' ')));
            });
            request.on('end', function () {
                console.log("Body: " + unescape(body.replace(/\+/g, ' ')));
            });
            response.writeHead(200, {
                'Content-Type': 'text/html'
            });
            response.end('post received');
        } else if (request.method == 'GET') {
            var uri = url.parse(request.url).pathname,
                filename = path.join(process.cwd(), uri);

            var contentTypesByExtension = {
                '.html': "text/html",
                '.css': "text/css",
                '.js': "text/javascript",
                '.dby': "text/plain"
            };

            console.log('HTTP GET: ' + filename);

            fs.exists(filename, function (exists) {
                if (!exists) {
                    console.log('HTTP 1');
                    response.writeHead(404, {
                        "Content-Type": "text/plain"
                    });
                    response.write("404 Not Found\n");
                    response.end();
                    return;
                }

                if (fs.statSync(filename).isDirectory()) filename += '/index.html';

                fs.readFile(filename, "binary", function (err, file) {
                    if (err) {

                        response.writeHead(500, {
                            "Content-Type": "text/plain"
                        });
                        response.write(err + "\n");
                        response.end();
                        return;
                    }


                    var headers = {};
                    var contentType = contentTypesByExtension[path.extname(filename)];
                    if (contentType) headers["Content-Type"] = contentType;
                    response.writeHead(200, headers);
                    response.write(file, "binary");
                    response.end();

                });
            });
        } else {
            console.log('HTTP: Unsupproted request: ' + request);
        }
    }).listen(Config.http_port);

    httpsrv.on('error', function (e) {
        console.log('HTTP server error' + e);
    });
}

// -- End webserver part

// -- Begin websocket part

if (httpsrv !== undefined) {
    console.log('Starting Websocket Server at: ' + Config.http_port);

    var wsServer = new WebSocketServer({
        httpServer: httpsrv,
        autoAcceptConnections: true
    });

    wsServer.on('connect', function(connection) {
        connection.nickname = Date.now().toString();
        console.log('Connection <' + connection.nickname + '> opened');
        connection.timout = Config.websock_timeout;

        (function watchdog() {
            if (connection.connected) {
                if (connection.timout <= 0) {
                    console.log('Connection <' + connection.nickname + '> timed out');
                    connection.close();
                    return;
                } else {
                    connection.timout -= 100;
                }
                setTimeout(watchdog, 100);
            }
        })();

        connection.on('message', function(message) {
            if (message.type === 'utf8') {
                connection.timout = Config.websock_timeout;
                var str = message.utf8Data;
                //console.log("recieved: " + str);
                if (str.indexOf('=') >= 0) {
                    wsServer.broadcastUTF(str);
                    TCP_broadcast('websocket', str + '\n');
                    //console.log('Meaditor write: '+medvar[0]+'='+medvar[1]);
                } else if (str == '*') { // Keepalive Ping
                    connection.sendUTF('*'); // Send pong
                }
                if (client.isOpen) {
                    if (str.indexOf('=') >= 0) {
                        wsServer.broadcastUTF(str);
                        var medvar = str.split('=');
                        client.writeVar({
                            path: medvar[0],
                            value: medvar[1]
                        });
                        //console.log('Meaditor write: '+medvar[0]+'='+medvar[1]);
                    } else if (str.indexOf('?') >= 0) { // Querry Mediator for existing variables
                        var medvar = str.split('?');
                        var defaultValue = '';
                        if (medvar.length > 1) {
                            defaultValue = medvar[1];
                        }
                        client.readVar(medvar[0], defaultValue);
                        //console.log('ReadVar: ' + medvar[0]);
                    } else if (str === '*') { // Keepalive Ping
                        connection.sendText('*'); // Send pong
                    }
                }
            }
        });

        connection.on('close', function(reasonCode, description) {
            wsServer.broadcastUTF(connection.nickname + ' left');
            console.log('Connection <' + connection.nickname + '> closed')
        });

        connection.on('error', function (e) {
            console.log('Websock connection <' + connection.nickname + '> error', e.message);
        });

    });

    wsServer.on('error', function (e) {
        console.log('Websock server error', e);
    });
}

// -- End websocket part

// Begin mediator part

console.log('Starting Mediator Client to ' + Config.mediator_host + ' : ' + Config.mediator_port);
var client = new MediatorGate({
    host: Config.mediator_host,
    port: Config.mediator_port,
    mask: Config.mediator_mask,
    autoReconnect: true,
    timestamp: 'abs'
});

client.on('connect', function onConnect() {
    console.log('mediator connection is established');
});
client.on('close', function onClose() {
    console.log('mediator connection is closed');
});
client.on('error', function onError(error) {
    console.error(error.stack);
});

var counter = 0;

client.on('update', function varsCommonUpdateHandler(varEntry) {
    //    console.log('Common update handler');
    wsServer.broadcastUTF(varEntry.path + "=" + varEntry.value + '@' + varEntry.ts);
    //    console.log(varEntry);
    if (varEntry.path == 'keepalive') counter = varEntry.value;
});

// -- End mediator part
