var MediatorGate = require('./mediator_lib');

var client = new MediatorGate({
	host: 'localhost',
	port: 7777,
	mask: '*',
	autoReconnect: true
});

client.on('connect', function onConnect() {
	console.log('mediator connection is established');
});
client.on('close', function onClose() {
	console.log('mediator connection is closed');
});
client.on('error', function onError(error) {
	console.error(error.stack);
});

client.on('update', function varsCommonUpdateHandler(varEntry) {
	console.log('Common update handler');
	console.log(varEntry);
});
client.subscribeUpdate('importantVar', function singleVarUpdateHandler(varEntry) {
	console.log('Partial update handler');
	console.log(varEntry);
});

client.once('connect', function () {
	//Read var example
	//Important to send reqests when connection have been established
	var defaultValue = 'default';
	client.readVar('importantVar', defaultValue); //sending request.
	//if everything is OK, reply will be notified by 'update' event (or with particular subscribed handler)
});

client.once('connect', sendCounter);
var counter = 0;
function sendCounter() {
	if (client.isOpen) {
		client.writeVar({
			path: 'counter',
			value: counter
		});
		counter++;
	}
	setTimeout(sendCounter, 1000);
}