var _und = require('underscore');
var util = require('util');
var Transform = require('stream').Transform;
var Readable = require('stream').Readable;

util.inherits(Parser, Transform);

function Parser(delimeter, bufferSize) {
	if (!_und.isRegExp(delimeter)) delimeter = new RegExp(delimeter);
	if (!_und.isNumber(bufferSize)) bufferSize = 1024;

	Transform.call(this, {
		encoding: 'utf8'
	});

	this.delimeter = delimeter;
	this.bufferSize = bufferSize;
}
Parser.prototype.buffer = '';
Parser.prototype.bufferSize = 1024;
Parser.prototype.delimeter = null;

Parser.prototype.reset = function() {
	this.buffer = '';
};

Parser.prototype._transform = function(data, enc, callback) {
	var parts = (this.buffer + data).split(this.delimeter); //split all data into packets
	this.buffer = parts.pop(); //last packet might be incomplete. storing it to buffer
	if (this.buffer.length > this.bufferSize) this.buffer = ''; //prevent memory overflows

	parts.forEach(Readable.prototype.push.bind(this)); //push lines to queue
	setImmediate(callback);
};
Parser.prototype._flush = function(callback) {
	this.reset();
	callback();
};

module.exports = Parser;