var MediatorGate = require('./mediator_lib');
var counter = 0;

var client = new MediatorGate({
    host: 'localhost',
    port: 7777,
    mask: '*',
    autoReconnect: true
});

client.on('connect', function onConnect() {
    console.log('mediator connection is established');
});
client.on('close', function onClose() {
    console.log('mediator connection is closed');
});
client.on('error', function onError(error) {
    console.error(error.stack);
});

client.on('update', function varsCommonUpdateHandler(varEntry) {
    console.log('Common update handler');
    console.log(varEntry);
});
client.subscribeUpdate('pathA.Var1', function singleVarUpdateHandler(varEntry) {
    console.log('Partial update handler');
    console.log(varEntry);
    if (varEntry.path == 'pathA.Var1') {
        console.log('Updating: counter = ' + varEntry.value);
        counter = varEntry.value;
    }
});

client.once('connect', function () {
    //Read var example
    //Important to send reqests when connection have been established
    var defaultValue = 'default';
    client.readVar('importantVar', defaultValue); //sending request.
    //if everything is OK, reply will be notified by 'update' event (or with particular subscribed handler)
});

var saw = 0;


client.once('connect', sendCounter);

function sendCounter() {
    if (client.isOpen) {
        var signal = Math.round(300 * Math.sin(counter * (355 / 1130))).toFixed(1);
        client.writeVar({
            path: 'pathA\\Var1',
            value: signal
        });
        counter++;

        saw += 25;
        if (saw >= 300) saw = 0;
        client.writeVar({
            path: 'pathA\\Var2',
            value: saw
        });
        client.writeVar({
            path: 'pathA\\Var3',
            value: (-1 * saw)
        });
    }
    setTimeout(sendCounter, 10);
}
